var configManager = {};

configManager.init = function() {
	var request = ['favoritesDisplay', 'screenshotDisplay', 'clearButtonDisplay', 'tagsTatus'];

	browser.extension.builtin.config.get(request, configManager.initCallback); 
};

configManager.initCallback = function(results) {
	try
	{
	    var config = eval("(" + results + ")")[0];
		// var config = {'favoritesOpen':true,'addressfieldInput':false,'tagPosition':'allTag','tagsTatus':'background'};    
	    
	    configManager.setView(config);
	}
	catch (e)
	{
		//alert(e.message);
	}
};

configManager.setView = function(config) {
	configManager.setTabOpenDisplay(config);
	configManager.setFavbarDisplay(config);
	configManager.setScreenshotDisplay(config);
	configManager.setClearButtonDisplay(config);
	configManager.setCloseConfirm(config);	// added by wilsonteng
};

// 设置标签前后台显示
configManager.setTabOpenDisplay = function(config) {
	if(!config.hasOwnProperty('tagsTatus')) {
		return;
	}	
	
	if(config.tagsTatus == 0) {
		// 显示前台按钮
		$('#background-button').hide();
		$('#foreground-button').show();
	} else {
		// 显示后台按钮
		$('#background-button').show();
		$('#foreground-button').hide();
	}
};

// 隐藏和显示收藏栏
configManager.setFavbarDisplay = function(config) {
	if(!config.hasOwnProperty('favoritesDisplay')) {
		return;
	}
	
	if(config.favoritesDisplay == false) {
		favbar.hide();
	} else if(config.favoritesDisplay == true) {
		favbar.show();
	}
};

// 隐藏和显示截屏按钮
configManager.setScreenshotDisplay = function(config) {
	if(!config.hasOwnProperty('screenshotDisplay')) {
		return;
	}	
	
	if(config.screenshotDisplay == false) {
		view.hideButton('capture-button');
	} else if(config.screenshotDisplay == true) {
		view.showButton('capture-button');
	}
};

// 隐藏和显示清除浏览痕迹按钮
configManager.setClearButtonDisplay = function(config) {
	if(!config.hasOwnProperty('clearButtonDisplay')) {
		return;
	}	
	
	if(config.clearButtonDisplay == false) {
		view.hideButton('clean-button');
	} else if(config.clearButtonDisplay == true) {
		view.showButton('clean-button');
	}
};

// added by wilsonteng
// 设置关闭确认
configManager.setCloseConfirm = function(config) {
	if(!config.hasOwnProperty('closeWndConfirm')) {
		return;
	}	
	eventManager.closeConfirm = config.closeWndConfirm;
};

configManager.getConfig = function(configArray, callback) {
	browser.extension.builtin.config.get(configArray, callback); 
};

/* config: key、value */
configManager.setConfig = function(config, callback) {
	if(!callback) {
		callback = function() {};
	}
	browser.extension.builtin.config.set(config, callback);
};